

<?php $__env->startSection('content'); ?>

<section class="as-productos">
    
    <div class="as-breadcrumb" aria-label="breadcrumb">
        <nav class="container-xxl">
            <ol class="breadcrumb as-breadcrumb">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(url('/')); ?>" title="E-Shop">Inicio</a>
                </li>
                <li class="breadcrumb-item" aria-current="page">
                   Productos
                </li>
                <?php if($productobuscar): ?>
                    <li class="breadcrumb-item" aria-current="page">
                    <?php echo e($productobuscar); ?>

                    </li>
                <?php endif; ?>
            </ol>
        </nav>
    </div>

    <div class="container-xxl container-fluid">

        <div class="row">
        
            <div class="col-auto me-auto">
                <button id="btnFilters" class="btn btn-dark d-lg-none d-xl-block d-xl-none d-xxl-none d-xxl-block bradius mb-4" collapse="false"><i class="fa fa-filter"></i> Filtrar</button>
            </div>
            
            <h1 class="col-lg-9 offset-lg-3 as-categorias-title as-page-title-style">
                Ofertas</h1>

            <aside class="col-lg-3">

                <div id="filter-params">

                    <?php if(count($productosxOfertas) > 0): ?>

                        <div class="as-categorias-fitler">
                            <form id="as-categorias-fitler-form" action="<?php echo e(url('collections/ofertas')); ?>" method="get">
                                <div class="row mb-3">
                                    <h3 class="col-12 pb-10 u"><span>Filtros</span></h3>
                                    <div class="form-group col-lg-12 col-md-12 col-12 mt-3">
                                        <p style="font-weight:bold !important;">PRODUCTO</p>
                                        <input type="text" class="form-control custom-form-input" name="productofertaBusc" id="productofertaBusc"
                                        placeholder="Ingrese el Producto" value="<?php echo e($productobuscar != "" ? $productobuscar : ''); ?>">
                                    </div>
                                
                                    <div class="col-12 mt-25">
                                        <p style="font-weight:bold !important;">PRECIO</p>
                                    </div>

                                    <div class="col-12 mt-2 px-4">
                                        <div id="precioSlider" class="slider-precio-style noUiSlider"></div>
                                        <div class="precioSlideRange d-flex justify-content-between">
                                            <span class="precioMinRange" id="priceMin"></span>
                                            <span class="precioMaxRange" id="priceMax"></span>
                                        </div>
                                        <input type="hidden" name="preciodOferta" id="preciodOferta" value="<?php echo e($precioD != "" ? $precioD : ''); ?>">
                                        <input type="hidden" name="preciohOferta" id="preciohOferta" value="<?php echo e($precioH != "" ? $precioH : ''); ?>">

                                    </div>



                                    <div class="col-12 text-right mt-25">
                                        <div class="form-group">
                                            <button type="submit" class="btn btn-dark btn--small bradius btn-buscarfilter btn-buscarfilter-style"><i class="fas fa-filter"></i> Búsqueda</button>
                                            <!-- <button type="button"class="btn btn-dark btn--small bradius" id="btnReset" name="btnReset" value="reset"><i class="fas fa-redo-alt"></i> Limpiar</button> -->
                                            <button type="button"class="btn btn-dark btn--small bradius" id="btnReset"><i class="fab fa-digital-ocean"></i> Limpiar</button>
                                        </div>
                                    </div>

                                </div>
                            </form>
                        </div>

                    <?php endif; ?>

                    <div class="as-categoria-tree">
                        <div class="row mb-3 mt-25">
                            <h3 class="col-12 pb-10 u"><span>Categorías</span></h3>
                            <div class="col-lg-12 col-md-12 col-12 mt-3">
                                <ul class="as-categoria-tree-list">
                                    <?php if(isset($categorias)): ?>
                                        <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ke=>$c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                            <?php if(!$c['sub_menu']): ?>
                                                <li class="mb-2"><span class="stylecat style-category-nav d-block">
                                                    <a href="<?php echo e(url('categorias/'.$c['url'])); ?>" class="site-nav"><?php echo e($c['categoria']); ?></a></span>
                                                </li> 
                                            <?php else: ?>
                                                <li>
                                                    <span class="stylecat style-category-nav d-flex justify-content-between align-items-center">
                                                        <a href="<?php echo e(url('categorias/'.$c['url'])); ?>" class="site-nav"><?php echo e($c['categoria']); ?></a>
                                                        <a class="drop-arrow" desplegado ="0">
                                                            <i class="fas fa-plus ct-show"></i>
                                                            <i class="fas fa-minus ct-hide hide"></i>
                                                        </a>
                                                        </span>
                                                        <ul class="sublinks">
                                                            <?php $__currentLoopData = $c['sub_menu']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kc=>$catsub): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <li class="level2">
                                                                    <a href="<?php echo e(url('categorias/'.$c['url'].'/'.$catsub['url'])); ?>" class="site-nav level2style"><?php echo e($catsub['categoria']); ?></a></li>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </ul>
                                                </li>
                                                
                                            <?php endif; ?>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                    
                                </ul>
                            </div>
                        </div>
                    </div>

                    <div class="as-etiquetas-tree">
                        <div class="row mb-3 mt-25">
                            <h3 class="col-12 pb-10 u"><span>Etiquetas</span></h3>
                            <div class="col-lg-12 col-md-12 col-12 mt-3">
                                <ul class="as-tags-tree-list">

                                <?php if(isset($etiquetas)): ?>
                                    <?php $__currentLoopData = $etiquetas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><a href="<?php echo e(url('etiquetas/'.$e->url)); ?>" title="<?php echo e($e->tag); ?>"><?php echo e($e->tag); ?></a></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>

                                </ul>
                            </div>
                        </div>
                    </div>

                </div>

            </aside>

            <article class="col-lg-9">

                <?php if(count($productosxOfertas) > 0): ?>
                    <div class="row pb-3">

                        <div class="col-md-8 col-sm-6"></div>

                        <div class="col-md-4 col-sm-6 d-flex justify-content-between align-items-center">

                            <?php $var = '' ?>
                            <?php if(isset($productobuscar)): ?>
                                <?php $var = "productBusc=".$productobuscar; ?>
                            <?php endif; ?>
                            <?php if(isset($precioD)): ?>
                                <?php $var .= "&preciod=".$precioD; ?>
                            <?php endif; ?>
                            <?php if(isset($precioH)): ?>
                                <?php $var .= "&precioh=".$precioH."&"; ?>
                            <?php endif; ?>
                            <label>Ordenar:</label>
                            <select name="SortBy" id="SortBy" class="form-control custom-form-input w-45 ms-3" onchange="location = this.value">
                                <option value="<?php echo e(url('collections/ofertas?'.$var.'orderProductOferta=defecto')); ?>" <?php echo e($order=='defecto' ? 'selected="selected"' : ''); ?>>Por defecto</option>
                                <option value="<?php echo e(url('collections/ofertas?'.$var.'orderProductOferta=precioasc')); ?>" <?php echo e($order=='precioasc' ? 'selected="selected"' : ''); ?>>Precio Ascendente</option>
                                <option value="<?php echo e(url('collections/ofertas?'.$var.'orderProductOferta=preciodesc')); ?>" <?php echo e($order=='preciodesc' ? 'selected="selected"' : ''); ?>>Precio Descendente</option>
                                <option value="<?php echo e(url('collections/ofertas?'.$var.'orderProductOferta=alfasc')); ?>" <?php echo e($order=='alfasc' ? 'selected="selected"' : ''); ?>>Alfabéticamente (A-Z)</option>
                                <option value="<?php echo e(url('collections/ofertas?'.$var.'orderProductOferta=alfdesc')); ?>" <?php echo e($order=='alfdesc' ? 'selected="selected"' : ''); ?>>Alfabéticamente (Z-A)</option>
                            </select>
                            <input class="collection-header__default-sort" type="hidden" value="manual">

                        </div>

                    </div>
                <?php endif; ?>

                <div class="row">

                    <?php $monedaactiva = $moneda[0]['prefijo']; ?>

                    <?php $precioMaxPro  = isset($precioMaxPro) ? $precioMaxPro : '0' ?>

                    <?php if(count($productosxOfertas) > 0): ?>

                        <?php $__currentLoopData = $productosxOfertas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pdata): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <?php $encryptProductId=Hashids::encode($pdata['producto_id']);?> 

                            <div class="col-md-c5 col-sm-c3 col-6 mt-3">

                                <div class="grid-producto h-100 d-flex flex-column">

                                    <div class="product-image">

                                        <a href="<?php echo e(url('producto/'.$pdata['url'])); ?>" class="text-decoration-none">

                                            <!-- Imagen Producto -->
                                            <img class="img-fluid" data-src="<?php echo e(asset($pdata['imgproducto'])); ?>" src="<?php echo e(asset($pdata['imgproducto'])); ?>" alt="Imagen Producto" title="<?php echo e($pdata['producto']); ?>">
                                            <!-- Fin Imagen Producto -->

                                            <!-- Descuento producto -->
                                            <?php if($pdata['descuento'] > 0): ?>
                                                <div class="descuento-tag rounded"><span class="lbl-discount"><p>-<?php echo e($pdata['descuento']); ?>%</p></span></div>
                                            <?php endif; ?>
                                            <!-- Fin Descuento Producto -->

                                        </a>

                                    </div>

                                    <div class="product-title mb-2">
                                        <!-- product name -->
                                        <a href="<?php echo e(url('producto/'.$pdata['url'])); ?>" class="grid-producto-nombre mt-auto" title="<?php echo e($pdata['producto']); ?>">
                                            <h3 class="grid-producto-title"><?php echo e($pdata['producto']); ?></h3>
                                        </a>
                                        <!-- End product name -->
                                    </div>

                                    <div class="product-details text-center mt-auto">
                                        <!-- product price -->
                                        <div class="text-center product-price">
                                            <?php if($pdata['precio_oferta']!= '0.00'): ?>
                                                <div class="old-price"><?php echo e($moneda[0]['prefijo'].' '.$pdata['precio']); ?></div>
                                                <div class="price"><?php echo e($moneda[0]['prefijo'].' '.$pdata['precio_oferta']); ?></div>
                                            <?php else: ?> 
                                                <div class="price"><?php echo e($moneda[0]['prefijo'].' '.$pdata['precio']); ?></div>
                                            <?php endif; ?>
                                        </div>
                                        <!-- End product price -->
                                        <!-- Color Variant -->

                                        <?php if($pdata['agotado']==0): ?>

                                            <div class="text-center" style="padding: 0 2px !important;">
                                                <a href="<?php echo e(url('producto/'.$pdata['url'])); ?>" class="btn btn-addto-cart btn-shop btn-block border-button style-btn-comprar" type="button" tabindex="0"><i class="fas fa-shopping-cart"></i> Comprar</a>
                                            </div>

                                        <?php else: ?> 
                                            <div class="text-center" style="padding: 0 2px !important;">
                                                <span class="btn label-agotado btn-block" style="margin-top: 1px; margin-bottom: 1px; font-size:13px; padding-top:5px; padding-bottom: 5px;"><i class="fas fa-exclamation-circle"></i> Agotado</span>
                                            </div>
                                        
                                        
                                        <?php endif; ?>

                                        <div class="detalles-product mt-2" style="padding-left:15px !important; padding-right:15px !important;">
                                            <a type="button" class="btn-styledetalles"  onclick="MostrarDetalleProductsG(<?php echo "'".$encryptProductId."'"; ?>, '<?php echo e(asset($pdata['imgproducto'])); ?>')"><i class="fas fa-search"></i> Ver detalles</a>                                    
                                        </div>
                                    </div>
                                    <!-- </div> -->
                                </div>

                            </div>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php else: ?> 

                        <div class="col">

                            <h2 class="display-4">Lo Sentimos</h2>
                            <p class="lead">No encontramos el producto que estas buscando</p>
                            <p class="lead">
                                <a class="btn btn-primary btn-lg bradius btn-principal btn-principal-style" href="<?php echo e(url('/')); ?>">Volver al inicio</a>
                            </p>

                        </div>

                    <?php endif; ?>

                </div>

                <?php echo e($productosxOfertas->appends(request()->query())->onEachSide(1)->links('front-partials.pagination-front')); ?>


            </article>

        </div>

    </div>


</section>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>

    <script>

        // Data para UI Slider de los Precios
        // console.log(<?php echo e($precioMaxPro); ?>);
        <?php if(count($productosxOfertas) > 0): ?>

        let dataPrecioInicio = 0;
        let dataPrecioFin = 0;
        <?php if($precioD != "") { ?>
            dataPrecioInicio = <?php echo $precioD ?>;
        <?php } ?>

        <?php if($precioH != "") { ?>
            dataPrecioFin = <?php echo $precioH ?>;
        <?php } 
        elseif(isset($precioMaxOfertas)) {?>
            dataPrecioFin = <?php echo $precioMaxOfertas ?>; 
        <?php 
        }
        ?>

        let precioSlider = document.getElementById('precioSlider');
        let PriceMin = document.getElementById('priceMin');
        let PriceMax = document.getElementById('priceMax');
        let precioD = document.getElementById('preciodOferta');
        let precioH = document.getElementById('preciohOferta');
        let rangemax = <?php echo $precioMaxOfertas ?>; 
 
        noUiSlider.create(precioSlider, {
            // options here
            start: [dataPrecioInicio, dataPrecioFin],
            range: {
                'min': [0],
                'max': [rangemax]
            },
            step: 1,
            tooltips: false,
            connect: true,
        });

        precioSlider.noUiSlider.on('update', function (values, handle) {

            let value = values[handle];

            if (handle) {
                PriceMax.innerHTML  = value;
                precioH.value = value;
                
            } else {
                PriceMin.innerHTML  = value;
                precioD.value = value;
            }
        });

        <?php endif; ?>

        // Limpiar Filtros
        $('#btnReset').click(function(){
            let url=$('meta[name=app-url]').attr("content") + "/collections/ofertas"
            window.location.href = url;
        })
        
        // Fin de la data para UI Slider de los Precios

        window.MostrarDetalleProductsG = function(producto, img)
        {
            $('#content_quickview').modal('show');
            url=$('meta[name=app-url]').attr("content") + "/producto/detalle/" +producto;
            $.ajax({
                url: url,
                method:'GET'
            }).done(function (data) {
                // console.log(img);
                let moneda = '<?php echo e($monedaactiva); ?>';
                $('#productdetalletitle').html(data.producto);
                $('#imgdetalleProducto').attr('src', img);
                $('#descripcion_productoDetalle').html("");
                $('#descripcion_productoDetalle').html(data.descripcion_producto);
                if(data.precio_oferta != '0.00')
                {
                  $('#precios_producto_detalle').html("");
                  $('#precios_producto_detalle').html('<span class="visually-hidden">Precio</span>'+
                                                        '<s id="ComparePrice-product-template"><span class="money" style="color:red;">'+moneda+' '+data.precio+'</span></s><br>'+
                                                        '<span class="product-price__price product-price__price-product-template product-price__sale product-price__sale--single"><span id="ProductPrice-product-template"><span class="money" style="color:black;">'+moneda+' '+data.precio_oferta+'</span></span></span>');  
                }
                else 
                {
                    $('#precios_producto_detalle').html("");
                    $('#precios_producto_detalle').html('<span class="visually-hidden">Precio</span>'+
                                                        '<span class="product-price__price product-price__price-product-template product-price__sale product-price__sale--single"><span id="ProductPrice-product-template"><span class="money" style="color:black;">'+moneda+' '+data.precio+'</span></span></span>');  
                }

                
            }).fail(function () {
                console.log("Error al cargar los datos");
            });
        }

    </script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\lolstore\resources\views/productosOfertas.blade.php ENDPATH**/ ?>