

<?php $__env->startSection('title', 'Módulo de Suscripciones'); ?>

<?php $__env->startSection('content'); ?>

<div class="content-wrapper">

    <div class="page-header row">

        <h3 class="page-title">
           ADMINISTRADOR DE SUSCRIPCIONES
        </h3>

        <div class="template-demo mt-20">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb breadcrumb-custom"">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>" class="colorfont"> <i class="fas fa-fw fa-home"></i> Inicio</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Suscripciones</li>
                </ol>
            </nav>
        </div>

    </div>

    <div class="row">
        
        <div class="col-12 grid-margin">

            <div class="card">

                <div class="card-body">
                    <h4 class="card-title">
                    <i class="fas fa-paper-plane"></i>
                        Listado de Emails Suscritos
                    </h4>
                    <section class="suscripciones">
                        <?php if(isset($suscripciones) && count($suscripciones) > 0): ?>
                    
                                <?php echo $__env->make('admin.data.load_suscritos_data', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        
                        <?php else: ?> 
                        
                                <div class="table-responsive">
                                    <table class="table">
                                        <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Email</th>
                                            <th>Acciones</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td align="center" colspan="3">No se encontraron registros</td>
                                            </tr>
                                    
                                        </tbody>
                                    </table>
                                </div>

                
                        <?php endif; ?>
                    </section>
                </div>

            </div>

        </div>

    </div>

    <div class="row justify-content-center">
            <div class="col-sm-5 align-self-center text-center">
                <div class="card">
                    <div class="card-body">
                        <table class="table align-items-center table-flush">
                            <thead class="thead-light">
                                <tr>
                                    <th colspan="2">Leyenda</th>
                                </tr>
                            </thead>
                            <tbody>
                
                                <tr>
                                    <td><img src="<?php echo e(url('admin_assets/images/delete3.png')); ?>" alt="Eliminar" style="width:22px;height:22px;"></td>
                                    <td style="font-size:14px">Eliminar Suscripción</td>
                                </tr>
                             
                            </tbody>
                        </table>
                    </div>
               </div>
            </div>
        </div>

</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

    <script>

        $(document).ready(function() {

            function loadsuscripciones(page)
            {
                let url='';
                url=$('meta[name=app-url]').attr("content")  + "/admin" + "/suscripciones?page="+page;

                $.ajax({
                    url: url,
                    method:'GET'
                }).done(function (data) {
                    $('.suscripciones').html(data);
                }).fail(function () {
                    console.log("Failed to load data!");
                });
            }

            window.eliminarSuscripcion = function(hddsuscripcion_id)
            {
                Swal.fire({
                    icon: 'warning',
                    title: 'Está seguro de eliminar la Suscripcion?',
                    showDenyButton: false,
                    showCancelButton: true,
                    confirmButtonColor: "#EB1010",
                    confirmButtonText: `Eliminar`,
                    cancelButtonText: `Cancelar`,
                    }).then((result) => {
                        if (result.isConfirmed) {
                            let url = $('meta[name=app-url]').attr("content") + "/admin/suscripciones/" + hddsuscripcion_id;
                            let data = {
                                suscripcion_id: hddsuscripcion_id
                            };
                            $.ajax({
                                headers: {
                                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                },
                                url: url,
                                type: "DELETE",
                                data: data,
                                success: function(response) {
                                    // console.log(response);
                                    if(response.code == "200")
                                    {
                                        loadsuscripciones();

                                        Swal.fire({
                                            icon: 'success',
                                            title: 'ÉXITO!',
                                            text: 'Se ha eliminado la Suscripción correctamente'
                                        });
                                    }
                                },
                                error: function(response) {                
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'ERROR...',
                                        text: 'Se ha producido un error al intentar eliminar el registro!'
                                    })
                                }
                            });
                        }
                    })
            }

        });

    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/logincmc/labodega.logincm.com/resources/views/admin/modules/suscripciones.blade.php ENDPATH**/ ?>