<?php

namespace App\Http\Controllers;

use App\Models\Configuracion;
use Illuminate\Http\Request;
use App\Models\AfiliacionActualizacionDatos;

class AfiliacionController extends Controller
{

    public function postAfiliacionActualizacionDatos(Request $request)
    {
        // Mensajes de error personalizados
        $messages = [
            'tipo_docLR.required' => 'El tipo de documento es obligatorio.',
            'nro_docLR.required' => 'El número de documento es obligatorio.',
            'nom_apeLR.required' => 'Es necesario ingresar los nombres y apellidos.',
            'direccionLR.required' => 'La dirección es obligatoria.',
            'telefonoLR.required' => 'El número de teléfono es obligatorio.',
            'correoLR.required' => 'El correo electrónico es obligatorio.',
            'correoLR.email' => 'El campo correo electrónico debe contener una dirección de correo válida.',
            'acepta_terminos.required' => 'Debe aceptar los términos y condiciones para continuar.',
            'acepta_terminos.accepted' => 'Debe aceptar los términos y condiciones para continuar.',
            'g-recaptcha-response.required' => 'Por favor verifica que no eres un robot.',
        ];
    
        // Validar los datos del formulario
        $validatedData = $request->validate([
            'tipo_docLR' => 'required',
            'nro_docLR' => 'required',
            'nom_apeLR' => 'required',
            'direccionLR' => 'required',
            'telefonoLR' => 'required',
            'correoLR' => 'required|email',
            'acepta_terminos' => 'required|accepted',
            'g-recaptcha-response' => 'required',
        ], $messages);
    
        // Verificar el reCAPTCHA manualmente
        $ip = $request->ip();
        $captcha = $request->input('g-recaptcha-response');
        $secretKey = Configuracion::get_valorxvariable('go_secret_key')->valor;
        $responseCaptcha = file_get_contents("https://www.google.com/recaptcha/api/siteverify?secret={$secretKey}&response={$captcha}&remoteip={$ip}");
        $validCaptcha = json_decode($responseCaptcha, true);
    
        if (!$validCaptcha['success']) {
            // Si el reCAPTCHA falla, redirigir al formulario con un error de reCAPTCHA
            return back()->withErrors(['captcha' => 'Error de validación de reCAPTCHA. Intenta nuevamente.'])->withInput();
        }
    
        // Crear un nuevo registro usando el modelo AfiliacionActualizacionDatos
        $registro = new AfiliacionActualizacionDatos();
        $registro->tipo_documento = $validatedData['tipo_docLR'];
        $registro->numero_documento = $validatedData['nro_docLR'];
        $registro->nombres = $validatedData['nom_apeLR'];
        $registro->direccion = $validatedData['direccionLR'];
        $registro->telefono = $validatedData['telefonoLR'];
        $registro->correo = $validatedData['correoLR'];
        $registro->acepta_terminos = $request->has('acepta_terminos');
        $registro->save();
    
        // Redirigir a una página de confirmación o de vuelta al formulario con un mensaje de éxito
        return redirect('afiliacion_actualizacion_datos')->with('status', 'Datos guardados con éxito!');
    }
    

}
